function design = coprime_1d(m, n, d)
%COPRIME_1D Generates a 1D co-prime array.
%Inputs:
%   m - Co-prime number pair.
%   n - Co-prime number pair.
%   d - Inter-element spacing.
name = sprintf('Co-prime array (%d, %d)', m, n);
cp = [(0:n-1) * m (1:2*m-1) * n];
design.element_indices = cp;
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.type = 'co-prime';
design.name = name;
end